#version 330 core

layout (location = 0) in vec3 aPos;
layout (location = 1) in vec3 aNormal;

out vec3 Color;

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

void main()
{
    // Pass the normal as color (X=red, Y=green, Z=blue)
    Color = aNormal;
    
    gl_Position = projection * view * model * vec4(aPos, 1.0);
}
