# μscope for Raspberry Pi v1.0.1

Real-time serial data visualization software for microcontrollers, optimized for Raspberry Pi.

## Features

- **Real-time Data Visualization**: Live plotting with line visualization
- **Serial Communication**: Support for /dev/ttyACM0 and other serial devices
- **CSV Recording**: Export data for analysis
- **Theme Support**: Light and dark themes
- **OpenGL ES 2.0**: Optimized for Raspberry Pi graphics

## Installation

1. Extract this archive: `unzip mscope-rpi-v1.0.1.zip`
2. Run the installer: `./install.sh`
3. Follow the installation prompts

## Usage

### Command Line
```bash
mscope-launcher
```

### Desktop
Find 'mscope' in your Applications menu

## Configuration

### Serial Port Access
To access serial ports, add your user to the dialout group:
```bash
sudo usermod -a -G dialout $USER
```
Then logout and login again.

### Plot Configuration
- Right-click on plot legends to access plot type options
- Use the Settings tab to configure themes and other preferences

## Requirements

- Raspberry Pi OS (or compatible Linux distribution)
- OpenGL ES 2.0 support
- Serial device (e.g., Arduino, ESP32, etc.)

## Version History

### v1.0.1 (Current)
- Initial release for Raspberry Pi
- Real-time line plot visualization
- Serial communication support
- CSV data recording
- Light/Dark theme support
- OpenGL ES 2.0 optimization

## Support

For issues and feature requests, please contact the development team.

---
**Version**: 1.0.1  
**Architecture**: ARM64 (Raspberry Pi)  
**Release Date**: September 2024